IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Centro_Costos_Saldos_Resumen_Anual') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Centro_Costos_Saldos_Resumen_Anual
END
GO


CREATE PROCEDURE dbo.CPJ_Centro_Costos_Saldos_Resumen_Anual @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Variables Recibidas por Parametros*/
DECLARE	@pId_Usuario			INT
DECLARE	@pFlagUsarTrans			TINYINT
DECLARE	@pModoDebug				TINYINT

DECLARE	@pAnio					SMALLINT

SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pAnio				        = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Anio')), 0)
/*FIN Variables Recibidas por Parametros*/

/*Variables Locales*/
DECLARE @Id_Centro_Costo						VARCHAR(10)
DECLARE @CC_Descripcion							VARCHAR(200)
DECLARE @Id_Centro_Costo_Saldo_Mas_Reciente		INT
DECLARE @Periodo_Mas_Reciente					DATE
DECLARE @Saldo_Mas_Reciente						DECIMAL(16,2)

DECLARE @rta_CPJ_Centro_Costos_Saldos_Resumen		TABLE (	Id_Centro_Costo			VARCHAR(10),
															Centro_Costo			VARCHAR(200),
															Ult_Periodo_Generado	DATE,
															Saldo					DECIMAL(16,2))
/*FIN Variables Locales*/

-------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@pModoDebug = 1)
BEGIN
	PRINT 'Ingreso a CPJ_Centro_Costos_Saldos_Resumen_Anual'
END

DECLARE curCentro_Costos_Saldos CURSOR FOR
SELECT DISTINCT CC.Id_Centro_Costo, ISNULL(CC.Descripcion, '') AS CC_Descripcion
FROM Centro_Costos CC, Centro_Costos_Saldos CCS
WHERE
CC.Id_Centro_Costo = CCS.Id_Centro_Costo
AND DATEPART(YEAR, CCS.Periodo) = @pAnio

OPEN curCentro_Costos_Saldos
FETCH NEXT FROM curCentro_Costos_Saldos INTO @Id_Centro_Costo, @CC_Descripcion
WHILE @@FETCH_STATUS = 0
BEGIN

	SET @Id_Centro_Costo_Saldo_Mas_Reciente = ISNULL((SELECT TOP 1 Id_Centro_Costo_Saldo
													FROM Centro_Costos_Saldos
													WHERE
													Id_Centro_Costo = @Id_Centro_Costo
													AND DATEPART(YEAR, Periodo) = @pAnio
													ORDER BY Periodo DESC)
													, 0)

	SELECT
	@Periodo_Mas_Reciente	= ISNULL(Periodo, '19000101'),
	@Saldo_Mas_Reciente		= ISNULL(Saldo, 0)
	FROM Centro_Costos_Saldos
	WHERE
	Id_Centro_Costo_Saldo = @Id_Centro_Costo_Saldo_Mas_Reciente

	INSERT INTO @rta_CPJ_Centro_Costos_Saldos_Resumen
	(Id_Centro_Costo, Centro_Costo, Ult_Periodo_Generado, Saldo)
	VALUES
	(@Id_Centro_Costo, @CC_Descripcion, @Periodo_Mas_Reciente, @Saldo_Mas_Reciente)

	FETCH NEXT FROM curCentro_Costos_Saldos INTO @Id_Centro_Costo, @CC_Descripcion
END
CLOSE curCentro_Costos_Saldos
DEALLOCATE curCentro_Costos_Saldos

SELECT * FROM @rta_CPJ_Centro_Costos_Saldos_Resumen

-------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@pModoDebug = 1)
BEGIN
	PRINT 'FIN CPJ_Centro_Costos_Saldos_Resumen_Anual'
END

/*
EXEC dbo.CPJ_Centro_Costos_Saldos_Resumen_Anual   '{
												"Id_Usuario":"-1",
												"FlagUsarTrans":"0",
												"ModoDebug":"1",
												"Anio":"2021"
												}'
*/